function CreateArmyAttackers()
	
	DZMineUA1 = UnlimitedArmy:New({
					Player = 6,
					Area = 2800,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	DZMineUA2 = UnlimitedArmy:New({
					Player = 6,
					Area = 2800,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	DZMineUA2.CommandDelayer = 5
	DZMineUA1.CommandDelayer = 5
	for i = 1,7,1 do
		DZMineUA1:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, GetPosition("EnemySpawn1"), 3)
		DZMineUA1:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, GetPosition("EnemySpawn1"), 3)
		DZMineUA2:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, GetPosition("EnemySpawn1"), 3)
		DZMineUA2:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, GetPosition("EnemySpawn1"), 3)
	end
	
	DZMineUA1:AddCommandWaitForIdle(false)
	DZMineUA1:AddCommandLuaFunc(ControllWayToMine,false)
	DZMineUA1:AddCommandWaitForIdle(false)
	DZMineUA1:AddCommandDefend(GetPosition("IronMinePos"),2800,true)
	DZMineUA2:AddCommandWaitForIdle(false)
	DZMineUA2:AddCommandLuaFunc(ControllWayToMine,false)
	DZMineUA2:AddCommandWaitForIdle(false)
	DZMineUA2:AddCommandDefend(GetPosition("IronMinePos"),2800,true)
	AntiKillTrigger = StartSimpleJob("AntiKill")
					

end

function ControllWayToMine(self)
	if self.CommandDelayer >= 0 then
		self.CommandDelayer = self.CommandDelayer -1
		return false
	else
		self.CommandDelayer = 5
	end
	local armyPos = self:GetPosition()
	if armyPos.X >= 31800 then
		if armyPos.Y >= 22700 and armyPos.Y <= 34900 then
			if self.Status ~= UnlimitedArmy.Status.Moving then
				return false, UnlimitedArmy.CreateCommandMove(GetPosition("IronMinePos"))
			end
		else
			if self.Status ~= UnlimitedArmy.Status.MovingNoBattle then
				return false, UnlimitedArmy.CreateCommandFlee(GetPosition("IronMinePos"))
			end
		end
	else
		if self.Status ~= UnlimitedArmy.Status.MovingNoBattle then
			return false, UnlimitedArmy.CreateCommandFlee(GetPosition("IronMinePos"))
		end
	end
	return false
end

function AntiKill()
	local MinePos = GetPosition("IronMinePos")
	if Logic.IsPlayerEntityInArea(1, MinePos.X, MinePos.Y, 3500, 8) == 0 then
		if GetDistance(DZMineUA1:GetPosition(),MinePos) <= 1000 and GetDistance(DZMineUA2:GetPosition(),MinePos) <= 1000 then
			if not CutsceneTriggered then
				DestroyStuffOutside()
				CutsceneTriggered = true
			end
		end
	end
	if DZMineUA1:GetSize(true,false) < 15 then
		AntiKillFlag = not AntiKillFlag
		if AntiKillFlag then
			DZMineUA1:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, GetPosition("EnemySpawn1"), 3)
		else
			DZMineUA1:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, GetPosition("EnemySpawn1"), 3)
		end
	end
	if DZMineUA2:GetSize(true,false) < 15 then
		AntiKillFlag1 = not AntiKillFlag1
		if AntiKillFlag1 then
			DZMineUA2:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, GetPosition("EnemySpawn1"), 3)
		else
			DZMineUA2:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, GetPosition("EnemySpawn1"), 3)
		end
	end
	return false 
end

function DestroyStuffOutside()
	GetOutsideBuildings()
	DZMineUA1:ClearCommandQueue()
	DZMineUA1:AddCommandMove({X=30600,Y=37900},false)
	DZMineUA1:AddCommandWaitForIdle(false)
	DZMineUA1:AddCommandLuaFunc(HuntBuildingsOutside,true)
	DZMineUA2:ClearCommandQueue()
	DZMineUA2:AddCommandMove({X=21300,Y=14000},false)
	DZMineUA2:AddCommandWaitForIdle(false)
	DZMineUA2:AddCommandLuaFunc(HuntBuildingsOutside,true)
end

function GetOutsideBuildings()
	BuildingsOutside = {}
	local OutsideSector = Logic.GetSector(GetID("EnemySpawn2"))
	for _buildingkey,_ in pairs(Player1Buildings) do
		if Logic.GetSector(_buildingkey) == OutsideSector then
			BuildingsOutside[_buildingkey] = true
			Logic.SetEntitySelectableFlag(_buildingkey, 0)
		end
	end
end

function HuntBuildingsOutside(self)
	local attackpos = GetFirstPosInTable(BuildingsOutside)
	if not attackpos then
		CallFuncOnce()
		return false
	end
	if self:IsIdle() then
		attackpos = KeyValueTableSetDistance(self,BuildingsOutside)
		return true, UnlimitedArmy.CreateCommandMove(GetPosition(attackpos),false)
	end
	return false
end

function KeyValueTableSetDistance(_UA,_table)
	local _uaPos = _UA:GetPosition()
	local distance = 10000000
	local tableentity = nil
	for _tableKey,_ in pairs(_table) do
		local tempdistance = GetDistance(_uaPos,GetPosition(_tableKey))
		if distance > tempdistance then
			distance = tempdistance
			tableentity = _tableKey
		end
		_table[_tableKey] = tempdistance
	end
	return tableentity
end

function GetFirstPosInTable(_table)
	local _pos = nil
	for _keypos, _ in pairs(_table) do
		_pos = _keypos
		break;
	end
	return _pos;
end

function CallFuncOnce()
	if calledonce ~= true then
		calledonce = true
		StartSimpleJob("ExecNewState")
	end
end

function ExecNewState()
	Trigger.UnrequestTrigger(AntiKillTrigger)
	for leaderID in  DZMineUA1:Iterator(transit) do
		Logic.DestroyGroupByLeader(leaderID)
	end
	for leaderID in  DZMineUA2:Iterator(transit) do
		Logic.DestroyGroupByLeader(leaderID)
	end
	StartBelagerung()
	return true
end